package Direct::Model::Banner::Constants;

=head1 NAME

=encoding utf8

Direct::Model::Banner::Constants - константы, доступные извне, вынесенные во избежание циклических зависимостей

=cut

use Direct::Modern;

=head2 BANNER_TYPES_WITHOUT_TITLE

    Типы баннеров, которые не имеют заголовка (title) или он техничейский (напр. заголовок image_ad = picture banner title)
    используется в письмах, чтобы не отправлять такие заголовки

=cut

our $BANNER_TYPES_WITHOUT_TITLE = [qw/image_ad dynamic performance mcbanner cpm_banner cpm_outdoor cpm_audio cpc_video cpm_indoor/];

=head2 BANNER_NO_LANGUAGE

    Значение поля banners.language при отсутствии языка в баннере

=cut

our $BANNER_NO_LANGUAGE = 'unknown';

1;
