package Direct::Model::Banner::LanguageUtils;

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;

use Direct::Model::Banner::Constants;

use Settings;

=head2 add_banners_to_fill_language_queue($bids_to_fill_language)

    Добавляет баннеры в очередь на заполнение языка

=cut

sub add_banners_to_fill_language_queue {
    my ($bids_to_fill_language) = @_;

    if (!defined $bids_to_fill_language || @$bids_to_fill_language == 0) {
        return;
    }

    foreach_shard bid => $bids_to_fill_language, chunk_size => 1000, sub {
        my ($shard, $bids) = @_;

        do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO banners_to_fill_language_queue (bid) VALUES %s", [map {[$_]} @$bids]);
    };

    return;
}

=head2 is_empty_language($language)

    Если язык неопределен - возвращает 1, иначе 0.

=cut

sub is_empty_language {
    my ($language) = @_;

    return !$language || $language eq $Direct::Model::Banner::Constants::BANNER_NO_LANGUAGE || $language eq 'Yes' || $language eq 'No';
}

1;
