package Direct::Model::Banner::Measurer;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;
use JSON;
use Direct::Model::AdGroup;

extends 'Yandex::ORM::Model::Base';

enum 'MEASURER_SYSTEM' => [qw/admetrica no mediascope adloox moat dv adriver sizmek integral_ad_science weborama omi ias omid/];

__PACKAGE__->_setup(
    default_table  => 'banner_measurers',

    fields => [
        banner_id        => { type => 'Id', column => 'bid' },
        measurer_system  => { type => 'MEASURER_SYSTEM' },
        params           => { type => 'Maybe[Str]' },
        has_integration  => { type => 'Bool', default => 0 },
    ],
    additional => [
        client_id        => {type => 'Id'},
        campaign_id      => {type => 'Id'},
        adgroup_id       => {type => 'Id'},
        creative_id      => {type => 'Maybe[Id]'},
        adgroup_type     => {type => Direct::Model::AdGroup::ADGROUP_TYPE },
    ],
);

sub to_template_hash {
    my $self = shift;
    return {
        measurer_system => $self->measurer_system,
        params => $self->params || '',
    }
}

use constant {
    ADLOOX_BANNER_TAG_ID => "880",
    ADLOOX_BANNER_CREATYPE => "2",

    ADLOOX_VIDEO_TAG_ID => "881",
    ADLOOX_VIDEO_CREATYPE => "6",
};

sub expand_params {
    my $self = shift;
    my $params = $self->params ? from_json($self->params) : {};
    if ($self->measurer_system eq 'moat') {
        my %moat = (
            moatClientLevel1 => $self->client_id,
            moatClientLevel2 => $self->campaign_id,
            moatClientLevel3 => $self->adgroup_id,
            moatClientLevel4 => $self->banner_id,
        );
        for (keys %moat) {
            $params->{$_} = sprintf '%d', $moat{$_} if !exists $params->{$_};
        }
        # DIRECT-116601: К moat добавить partnerCode
        $params->{partnerCode} = "yandexhostedvideo786420153684";
    } elsif ($self->measurer_system eq 'adloox') {
        my %adloox = (
            id2 => $self->campaign_id,
            id5 => $self->banner_id,
            id7 => $self->client_id,
        );
        for (keys %adloox) {
            $params->{$_} = sprintf '%d', $adloox{$_} if !exists $params->{$_};
        }
        ($params->{tagid}, $params->{creatype}) = $self->adgroup_type eq 'cpm_video' ? (ADLOOX_VIDEO_TAG_ID, ADLOOX_VIDEO_CREATYPE) : (ADLOOX_BANNER_TAG_ID, ADLOOX_BANNER_CREATYPE);
    }
    elsif ($self->measurer_system eq 'ias') {
    }
    elsif ($self->measurer_system eq 'omid') {
        my $advid = $params->{advid};
        my $pubid = $params->{pubid};

        if (defined $advid && defined $pubid) {
            $params = [
                        {
                          "vendor"=> "IAS",
                          "javaScriptResource"=> "https://verify.yandex.ru/verify_ias/static/fw.js?ias_campId=".$self->campaign_id."&ias_placementId=".$self->adgroup_id,
                          "trackingEvents"=> [],
                          "verificationParameters"=> {
                            "config"=> "/verify_ias/jsconfig/rjss/yandex/".$advid."/".$pubid."/skeleton.js?iasProxyPartnerId=32908",
                            "host"=> "https://verify.yandex.ru"
                          }
                         }
                      ];
        }
        else {
            $params = undef;
        }
    }

    return $params;
}

1;
