package Direct::Model::BannerContentPromotion;

use Direct::Modern;
use Lang::Guess qw/analyze_text_lang_with_context/;
use Mouse;
use Mouse::Util::TypeConstraints;

use Direct::Model::Banner::LanguageUtils;

extends 'Direct::Model::Banner';

#
# Баннер продвижения контента: отсутствуют картинка, сайтлинки, визитка
#

__PACKAGE__->_setup(
    default_table  => 'banners',
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        content_promotion_content_id => { type => 'Id' },
        content_promotion_content_href => { type => 'Maybe[Str]' },
        content_promotion_preview_url => { type => 'Maybe[Str]' },
        content_promotion_visit_url => { type => 'Maybe[Str]' },
    ],
);

has '+banner_type'    => (isa => enum(['content_promotion']), lazy => 0, builder => sub { 'content_promotion' });
has '+title_extension'  => (isa => 'Undef', builder => sub { undef });
has '+vcard_id'         => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id' => (isa => 'Undef', builder => sub { undef });

has '+adgroup'       => (isa => 'Direct::Model::AdGroupContentPromotion');
has '+vcard'         => (isa => 'Undef');
has '+sitelinks_set' => (isa => 'Undef');
has '+is_mobile'     => (isa => 'OnlyFalse', builder => sub { 0 });

sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub adgroup_class { 'Direct::Model::AdGroupContentPromotion' }

sub detect_lang {
    my $self = shift;

    if (Direct::Model::Banner::LanguageUtils::is_empty_language($self->language)) {
        return analyze_text_lang_with_context($self->client_id, join ' ', $self->title // (), $self->body // ()) || 'ru';
    } else {
        return $self->language;
    }
}

1;
