package Direct::Model::BannerCpcVideo::Manager;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::Banner::Manager';

use Settings;

use Direct::Model::BannerCpcVideo;
use Direct::Model::BannerCreative::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerCpcVideo]');

=head2 _create_in_shard($shard, $banners)

Внутренний метод.
Создание в БД в определённом шарде записей для соответствующих объектов

=cut

sub _create_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_create_in_shard($shard, $banners);
    my @creatives = map { $_->creative } @$banners;
    Direct::Model::BannerCreative::Manager->new(items => \@creatives)->create();

    return;
}

=head2 _update_in_shard($shard, $banners, %options)

Внутренний метод.
Обновление в БД в определённом шарде записей для соответствующих объектов.

=cut

sub _update_in_shard {
    my ($self, $shard, $banners, %options) = @_;
    $self->SUPER::_update_in_shard($shard, $banners, %options);
    my @creatives = map { $_->creative } @$banners;
    Direct::Model::BannerCreative::Manager->new(items => \@creatives)->update();

    return;
}

=head2 _delete_in_shard($shard, $banners)

Внутренний метод.
Удаление из БД в определённом шарде записей для соответствующих объектов.

=cut

sub _delete_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_delete_in_shard($shard, $banners);

    return;
}


__PACKAGE__->meta->make_immutable;

1;
