
package Direct::Model::BannerCpmBanner;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Direct::Model::BannerImageAd::Constants;
use Direct::Model::AdGroupCpmBanner;
use Direct::Model::AdGroupCpmVideo;
use Yandex::I18n;

extends 'Direct::Model::Banner';

__PACKAGE__->_setup(
    default_table  => 'banners',
    manager_class  => __PACKAGE__.'::Manager',

    relations => [
        creative => { type => 'Direct::Model::BannerCreative'},
        pixels => { type => 'ArrayRef[Direct::Model::Pixel]' },
    ],

    state_flags => [qw/
        pixels_change
    /],
);

sub BUILD {
    my ($self) = @_;
    $self->_set_attr_raw_value(body => $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER);#ToDo подумать, что тут правильнее счделать
    $self->_set_attr_raw_value(title => $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER);
}

has '+banner_type'          => (isa => enum(['cpm_banner']), lazy => 0, builder => sub { 'cpm_banner' });
has '+title_extension'      => (isa => 'Maybe[Str]', builder => sub { undef });
has '+is_mobile'            => (isa => 'OnlyFalse', builder => sub { 0 });
has '+vcard_id'             => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id'     => (isa => 'Undef', builder => sub { undef });
has '+image_hash'           => (isa => 'Undef', builder => sub { undef });

has '+vcard'                => (isa => 'Undef');
has '+sitelinks_set'        => (isa => 'Undef');
has '+additions_callouts'   => (isa => 'Undef');
has '+image'                => (isa => 'Undef');

has '+adgroup'              => (isa => 'Direct::Model::AdGroupCpmBanner | Direct::Model::AdGroupCpmVideo');

#ToDo методы с child_* пока не добавляю, посмотрю, насколько они нужны

sub get_name {
    my $self = shift;
    return $self->creative->get_name();
}

sub get_width {
    my $self = shift;
    return $self->creative->get_width();
}

sub get_height {
    my $self = shift;
    return $self->creative->get_height();
}

sub get_preview_url {
    my $self = shift;
    return $self->creative->get_preview_url();
}

sub get_scale_size {
    my $self = shift;
    return $self->creative->get_scale_size();
}

sub detect_lang {
    my $self = shift;
    return $self->creative->creative->detect_lang if $self->has_creative;
}

sub to_template_hash {
    my $self = shift;
    return {
        name => $self->get_name(),
        width => $self->get_width(),
        height => $self->get_height(),
        preview_url => $self->get_preview_url(),
        scale => $self->get_scale_size(),
        creative => $self->creative->to_template_hash(),
        $self->has_turbolanding ? 
            (turbolanding => $self->turbolanding->to_template_hash()) :
            ()
    };
}

sub is_title_extension_supported { 1 }
sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub is_image_supported { 0 }
sub is_imagead_supported { 1 }#ToDo тут я пока не уверен, используется только в API, надо посмотреть
sub is_pixels_supported { 1 }
sub is_turbolanding_supported { 1 }

sub adgroup_class { 'Direct::Model::AdGroupCpmBanner' }

=head2 pixel_urls_str

формируем строку из отсортированных урлов пикселов с разделителем

=cut

sub pixel_urls_str {
    my ($self) = @_;
    return $self->has_pixels ? join(',', sort map {$_->url} @{$self->pixels}) : '';
}

1;

