package Direct::Model::BannerCpmBanner::Manager;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::Banner::Manager';

use Settings;

use Direct::Model::BannerCpmBanner;
use Direct::Model::BannerCreative::Manager;
use Direct::BannersPixels;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerCpmBanner]');

=head2 _create_in_shard($shard, $banners)

Внутренний метод.
Создание в БД в определённом шарде записей для соответствующих объектов

=cut

sub _create_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_create_in_shard($shard, $banners);
    my @creatives = map { $_->creative } @$banners;
    Direct::Model::BannerCreative::Manager->new(items => \@creatives)->create();

    $self->_do_update_pixels($shard, [grep { $_->has_pixels } @$banners]);

    return;
}

=head2 _update_in_shard($shard, $banners, %options)

Внутренний метод.
Обновление в БД в определённом шарде записей для соответствующих объектов.

=cut

sub _update_in_shard {
    my ($self, $shard, $banners, %options) = @_;
    $self->SUPER::_update_in_shard($shard, $banners, %options);
    my @creatives = map { $_->creative } @$banners;
    Direct::Model::BannerCreative::Manager->new(items => \@creatives)->update();

    $self->_do_update_pixels($shard, [grep { $_->do_pixels_change } @$banners]);

    return;
}

=head2 _delete_in_shard($shard, $banners)

Внутренний метод.
Удаление из БД в определённом шарде записей для соответствующих объектов.

=cut

sub _delete_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_delete_in_shard($shard, $banners);

    return;
}

=head2 _do_update_pixels

  Привязка/отвязка пикселов

=cut

sub _do_update_pixels {
    my ($self, $shard, $banners) = @_;

    my (@pixels, @banners_without_pixels);
    for my $banner (@$banners) {
        if ($banner->has_pixels && @{$banner->pixels}) {
            $_->banner_id($banner->id) foreach @{$banner->pixels};
            push @pixels, @{$banner->pixels};
        } else {
            push @banners_without_pixels, $banner->id;
        }
    }

    if (@pixels) {
        Direct::BannersPixels->new(items => \@pixels)->save();
    }

    if (@banners_without_pixels) {
        Direct::BannersPixels::delete_banner_pixels(\@banners_without_pixels);
    }

    return;
}


__PACKAGE__->meta->make_immutable;

1;
