package Direct::Model::BannerCpmIndoor;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;

use Direct::Model::VideoAddition;
use Direct::Model::BannerImageAd::Constants;

extends 'Direct::Model::Banner';

__PACKAGE__->_setup(
    default_table  => 'banners',
    manager_class  => __PACKAGE__.'::Manager',

    relations => [
        creative => { type => 'Direct::Model::BannerCreative' },
    ],
);

sub BUILD {
    my ($self) = @_;
    $self->_set_attr_raw_value(body => $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER);
    $self->_set_attr_raw_value(title => $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER);
}

has '+banner_type'          => (isa => enum(['cpm_indoor']), lazy => 0, builder => sub { 'cpm_indoor' });
has '+title'                => (is => 'rw', builder => sub { $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER });
has '+title_extension'      => (isa => 'Undef', builder => sub { undef });
has '+body'                 => (is => 'rw', builder => sub { $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER } );
has '+is_mobile'            => (isa => 'OnlyFalse', builder => sub { 0 });
has '+vcard_id'             => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id'     => (isa => 'Undef', builder => sub { undef });
has '+image_hash'           => (isa => 'Undef', builder => sub { undef });
has '+filter_domain'        => (is => 'rw', isa => 'Maybe[Str]', );

has '+vcard'                => (isa => 'Undef');
has '+sitelinks_set'        => (isa => 'Undef');
has '+additions_callouts'   => (isa => 'Undef');
has '+image'                => (isa => 'Undef');

has '+adgroup'              => (isa => 'Direct::Model::AdGroupCpmBanner');

sub get_name {
    my $self = shift;
    return $self->creative->get_name();
}

sub get_width {
    return $Direct::Model::VideoAddition::FAKE_VIDEO_WIDTH;
}

sub get_height {
    return $Direct::Model::VideoAddition::FAKE_VIDEO_HEIGHT;
}

sub get_preview_url {
    my $self = shift;
    return $self->creative->get_preview_url();
}

sub get_scale_size {
    my $self = shift;
    return $self->creative->get_scale_size();
}

sub detect_lang {
    my $self = shift;
    return $self->creative->creative->detect_lang if $self->has_creative;
}

sub to_template_hash {
    my $self = shift;
    return {
        name => $self->get_name(),
        width => $self->get_width(),
        height => $self->get_height(),
        preview_url => $self->get_preview_url(),
        scale => $self->get_scale_size(),
        creative => $self->creative->to_template_hash(),
    };
}

sub is_title_supported { 0 }
sub is_body_supported { 0 }
sub is_href_supported { 0 }
sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub is_image_supported { 0 }
sub is_imagead_supported { 1 }

sub adgroup_class { 'Direct::Model::AdGroupCpmBanner' }

1;
