package Direct::Model::BannerCreative;

use Direct::Modern;
use Mouse;
use Direct::Model::CanvasCreative;
use Direct::Model::CanvasHtml5Creative;
use Direct::Model::VideoAddition;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';


__PACKAGE__->_setup(
    default_table  => 'banners_performance',

    fields => [
        id                        => { type => 'Id', column => 'banner_creative_id', primary_key => 1 },
        campaign_id               => { type => 'Id', column => 'cid' },
        adgroup_id                => { type => 'Id', column => 'pid' },
        banner_id                 => { type => 'Id', column => 'bid' },
        creative_id               => { type => 'Id' },
        status_moderate           => { type => 'Enum', values => [qw/Yes No Sent Sending Ready New/], column => 'statusModerate', default => 'New', volatile => 1 },
        extracted_text            => { type => 'Maybe[Str]', column => 'extracted_text' },
    ],

    relations => [
        creative => { type => 'Direct::Model::Creative | Direct::Model::CanvasCreative | Direct::Model::CanvasHtml5Creative | Direct::Model::VideoAddition' },
    ],

    # Additional attributes
    additional => [
        rejection_reason_ids => { type => 'ArrayRef[Int]',  default => sub { [] } },
        export_version       => { type => 'Maybe[Str]' },
        force                => { type => 'Bool', default => 0 },
    ],
);

sub get_name { return shift->creative->name; }
sub get_width { return shift->creative->width; }
sub get_height { return shift->creative->height; }
sub get_preview_url { return shift->creative->preview_url; }
sub get_scale_size { shift->creative->get_scale_size; }

sub to_template_hash {
    my $self = shift;

    my $cr = $self->creative;
    my $hash = {
        creative_id => $cr->id,
        # убрать все кроме creative_id после DIRECT-57421 # todo@dima117a не меняйте формат без согласования с фронтендом!!
        creative_type => $cr->creative_type,
        ($cr->creative_type eq 'html5_creative' ? (composed_from => $cr->composed_from) :("composed_from" => "")),
        width => $cr->width,
        height => $cr->height,
        name => $cr->name,
        scale => scalar $self->get_scale_size,
        preview_url => $cr->preview_url,
        live_preview_url => $cr->live_preview_url,
        canvas_tags => $cr->get_canvas_tags(),
        has_packshot => $cr->has_has_packshot && defined $cr->has_packshot ? int($cr->has_packshot) : undef,
        is_adaptive => $cr->is_adaptive,
    };

    # проставляем фейковые размеры для видео - нужно для вёрстки
    # https://st.yandex-team.ru/DIRECT-79290#1527152683000
    if ($cr->creative_type eq 'video_addition') {
        $hash->{height} ||= $cr->get_height();
        $hash->{width} ||= $cr->get_width();
        $hash->{additional_data} = $cr->additional_data_to_template;
        $hash->{duration} = $cr->get_duration;
    }

    return $hash;
}

1;

