package Direct::Model::BannerCreative::Manager;
use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use JavaIntapi::GenerateObjectIds;

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::BannerCreative]',
);

sub create
{
    my ($self, %opt) = @_;

    my $new_ids = JavaIntapi::GenerateObjectIds->new(object_type => 'banner_creative',
            count => scalar @{$self->items})->call();
    foreach_shard cid => $self->items, by => sub { $_->campaign_id }, sub {
        my ($shard, $shard_items) = @_;
        $_->id(shift @$new_ids) for @$shard_items;
        $self->_insert_to_one_table_in_db(PPC(shard => $shard), 'banners_performance', undef, $shard_items);
    };
}

sub update
{
    my ($self, %opt) = @_;

    my @items = grep { $_->id } @{$self->items};

    foreach_shard cid => \@items, by => sub { $_->campaign_id }, sub {
        my ($shard, $shard_items) = @_;
        $self->_update_one_table_in_db(PPC(shard => $shard), 'banners_performance', 'banner_creative_id', $shard_items);
    };
}

sub delete
{
    my ($self, %opt) = @_;
    
    my @items = grep { $_->id } @{$self->items};
    
    foreach_shard cid => \@items, by => sub { $_->campaign_id }, sub {
        my ($shard, $shard_items) = @_;
        my @ids = map { $_->id } @$shard_items;
        do_delete_from_table(PPC(shard => $shard), 'banners_performance', where => { banner_creative_id => \@ids });
    };
}

__PACKAGE__->meta->make_immutable;

1;
