package Direct::Model::BannerDynamic;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;
use Lang::Guess qw/analyze_text_lang_with_context/;

use Direct::Model::Banner::LanguageUtils;

extends 'Direct::Model::Banner';

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    state_flags => [qw/
        set_adgroup_bl_status
    /],
);

#
# Динамический баннер: фиксированный title, is_mobile всегда False, отсутствует href/domain/domain_id/reverse_domain
#

sub BUILD {
    my ($self) = @_;
    $self->_set_attr_raw_value(title => iget('{Динамический заголовок}'));
}

has '+banner_type'		=> (isa => enum(['dynamic']), lazy => 0, builder => sub { 'dynamic' });
has '+title'          	=> (is => 'ro');
has '+title_extension'  => (isa => 'Undef', builder => sub { undef });
has '+is_mobile'		=> (isa => 'OnlyFalse', builder => sub { 0 });
has '+href'           	=> (isa => 'Undef', builder => sub { undef });
has '+domain_id'      	=> (isa => 'Undef', builder => sub { undef });
has '+domain'         	=> (isa => 'Undef', builder => sub { undef });
has '+reverse_domain' 	=> (isa => 'Undef', builder => sub { undef });

has '+adgroup' => (isa => 'Direct::Model::AdGroupDynamic');

sub is_title_supported { 0 }

sub is_href_supported { 0 }
sub is_callouts_supported { 1 }
sub adgroup_class { 'Direct::Model::AdGroupDynamic' }
sub is_disable_display_href_supported { 1 }

sub detect_lang {
    my $self = shift;

    if (Direct::Model::Banner::LanguageUtils::is_empty_language($self->language)) {
        return analyze_text_lang_with_context($self->client_id, $self->body) || 'ru';
    } else {
        return $self->language;
    }
}

1;
