package Direct::Model::BannerImage;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';


__PACKAGE__->_setup(
    default_table  => 'banner_images',

    fields => [
        id              => { type => 'Id', column => 'image_id', primary_key => 1 },
        banner_id       => { type => 'Id', column => 'bid' },
        hash            => { type => 'Str', column => 'image_hash' },
        bs_banner_id    => { type => 'Id', column => 'BannerID', default => 0 },
        bs_priority_id  => { type => 'Id', column => 'PriorityID', default => 0 },
        name            => { type => 'Maybe[Str]', length => 255 },
        status_moderate => { type => 'Enum', values => [qw/Yes No Sent Sending Ready New/], column => 'statusModerate', default => 'New', volatile => 1 },
        status_show     => { type => 'Enum', values => [qw/Yes No/], column => 'statusShow', default => 'Yes' },
        date_added      => { type => 'Timestamp' },

#        type            => { type => 'Maybe[Enum]', values => [qw/small regular wide image_ad/], column => 'image_type', table => 'banner_images_formats' },
    ],

    relations => [
        format => { type => 'Direct::Model::ImageFormat', key => 'image_hash' },
    ],
);

1;
