package Direct::Model::BannerImageAd;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

extends 'Direct::Model::Banner';
# При динамическом назначении роли инстансу через apply_all_roles
#> apply_all_roles($banner->meta, Direct::Model::BannerImage::Role::Url->meta);
# роль расширяет класс и ее получают все инстансы этого класса.
#
# Назначим ее сразу
with 'Direct::Model::BannerImage::Role::Url';


__PACKAGE__->_setup(
    default_table  => 'banners',
    manager_class  => __PACKAGE__.'::Manager',

    relations => [
        image_ad => { type => 'Direct::Model::Image', trigger => \&_on_image_ad_changed },
        creative => { type => 'Direct::Model::BannerCreative', trigger => \&_on_creative_changed },
    ],
);

around BUILDARGS => sub {
    my ($orig, $class) = (shift, shift);
    my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;
    croak "Cannot apply `image_ad` and `creative` together" if defined $args{image_ad} && defined $args{creative};
    delete $args{image}; # убрать после в базе есть баннеры (~1000) с двумя картинками (images и banner_images), такие баннеры ломают BannerImageAd, поэтому явны вырезаем image из хеша $banner. Убрать после DIRECT-58780
    $class->$orig(%args);
};

sub BUILD {
    my ($self) = @_;
}

has '+banner_type'      => (isa => enum(['image_ad']), lazy => 0, builder => sub { 'image_ad' });
has '+title'            => (is => 'ro', builder => sub { undef });
has '+title_extension'  => (is => 'ro', builder => sub { undef });
has '+body'             => (is => 'ro', builder => sub { undef });

has '+vcard_id'         => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id' => (isa => 'Undef', builder => sub { undef });

has '+vcard'         => (isa => 'Undef');
has '+sitelinks_set' => (isa => 'Undef');
has '+is_mobile' => (isa => 'OnlyFalse', builder => sub { 0 });

has '+image' => (isa => 'Undef');

sub _on_image_ad_changed {
    my $self = shift;
    croak "Cannot apply `image_ad` because `creative` already set" if $self->has_creative;
}

sub _on_creative_changed {
    my $self = shift;
    croak "Cannot apply `creative` because `image_ad` already set" if $self->has_image_ad;
}

sub _build_url {
    my $self = shift;
    croak sprintf('Banner %s: Url must be setted before using!', $self->id);
}

sub child_campaign_id {
    my $self = shift;
    if (@_) {
        my $campaign_id = shift;
        if ($self->has_image_ad) {
            $self->image_ad->campaign_id($campaign_id);
        } else {
            $self->creative->campaign_id($campaign_id);
        }
    } else {
        return $self->has_image_ad ? $self->image_ad->campaign_id : $self->creative->campaign_id;
    }
}

sub child_adgroup_id {
    my $self = shift;
    if (@_) {
        my $adgroup_id = shift;
        if ($self->has_image_ad) {
            $self->image_ad->adgroup_id($adgroup_id);
        } else {
            $self->creative->adgroup_id($adgroup_id);
        }
    } else {
        return $self->has_image_ad ? $self->image_ad->adgroup_id : $self->creative->adgroup_id;
    }
}

sub child_banner_id {
    my $self = shift;
    if (@_) {
        my $banner_id = shift;
        if ($self->has_image_ad) {
            $self->image_ad->banner_id($banner_id);
        } else {
            $self->creative->banner_id($banner_id);
        }
    } else {
        return $self->has_image_ad ? $self->image_ad->banner_id : $self->creative->banner_id;
    }
}

sub child_status_moderate {
    my $self = shift;
    if (@_) {
        my $status_moderate = shift;
        if ($self->has_image_ad) {
            $self->image_ad->status_moderate($status_moderate);
        } else {
            $self->creative->status_moderate($status_moderate);
        }
        return $status_moderate;
    } else {
        return $self->has_image_ad ? $self->image_ad->status_moderate : $self->creative->status_moderate;
    }
}

sub child_has_status_moderate {
    my $self = shift;
    return $self->has_image_ad ? $self->image_ad->has_status_moderate : $self->creative->has_status_moderate;
}

sub is_child_changed {
    my $self = shift;
    return $self->has_image_ad ? $self->image_ad->is_hash_changed : $self->creative->is_creative_id_changed;
}

sub get_name {
    my $self = shift;
    return $self->image_ad->get_name() if $self->has_image_ad;
    return $self->creative->get_name();
}

sub get_width {
    my $self = shift;
    return $self->image_ad->get_width() if $self->has_image_ad;
    return $self->creative->get_width();
}

sub get_height {
    my $self = shift;
    return $self->image_ad->get_height() if $self->has_image_ad;
    return $self->creative->get_height();
}

sub get_preview_url {
    my $self = shift;
    return $self->image_ad->get_preview_url() if $self->has_image_ad;
    return $self->creative->get_preview_url();
}

sub get_scale_size {
    my $self = shift;
    return $self->image_ad->get_scale_size() if $self->has_image_ad;
    return $self->creative->get_scale_size();
}

sub detect_lang {
    my $self = shift;
    # порядок изменен для Direct::Banners::get_lang_banners
    return $self->creative->creative->detect_lang if $self->has_creative;
    # язык для баннера по изображению
    return 'ru';
}

sub to_template_hash
{
    my $self = shift;
    return {
        name => $self->get_name(),
        width => $self->get_width(),
        height => $self->get_height(),
        preview_url => $self->get_preview_url(),
        scale => $self->get_scale_size(),
        $self->has_image_ad ?
            ( image_ad => $self->image_ad->to_template_hash ) :
            ( creative => $self->creative->to_template_hash ),
        $self->has_turbolanding ? 
            (turbolanding => $self->turbolanding->to_template_hash()) :
            ()
    };
}

sub is_title_supported { 0 }
sub is_body_supported { 0 }
sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub is_image_supported { 0 }
sub is_imagead_supported { 1 }
sub is_turbolanding_supported { 1 }

# для сопоставления языка и региона BannerImageAd тип группы не важен. Функция используется только для этого.
sub adgroup_class { 'Direct::Model::AdGroupText' }

1;

