package Direct::Model::BannerImageAd::Manager;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::Banner::Manager';

use Settings;

use Direct::Model::BannerImageAd;
use Direct::Model::Image::Manager;
use Direct::Model::BannerCreative::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerImageAd]');

=head2 _create_in_shard($shard, $banners)

Внутренний метод.
Создание в БД в определённом шарде записей для соответствующих объектов

=cut

sub _create_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_create_in_shard($shard, $banners);
    my @images = map { $_->image_ad } grep { $_->has_image_ad } @$banners;
    Direct::Model::Image::Manager->new(items => \@images)->create();
    my @creatives = map { $_->creative } grep { $_->has_creative } @$banners;
    Direct::Model::BannerCreative::Manager->new(items => \@creatives)->create();

    return;
}

=head2 _update_in_shard($shard, $banners, %options)

Внутренний метод.
Обновление в БД в определённом шарде записей для соответствующих объектов (перфоманс объявлений).

=cut

sub _update_in_shard {
    my ($self, $shard, $banners, %options) = @_;
    $self->SUPER::_update_in_shard($shard, $banners, %options);
    my @images = map { $_->image_ad } grep { $_->has_image_ad } @$banners;
    Direct::Model::Image::Manager->new(items => \@images)->update();
    my @creatives = map { $_->creative } grep { $_->has_creative } @$banners;
    Direct::Model::BannerCreative::Manager->new(items => \@creatives)->update();

    return;
}

=head2 _delete_in_shard($shard, $banners)

Внутренний метод.
Удаление из БД в определённом шарде записей для соответствующих объектов (перфоманс объявлений).

=cut

sub _delete_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_delete_in_shard($shard, $banners);

    return;
}

__PACKAGE__->meta->make_immutable;

1;

