package Direct::Model::BannerMcbanner;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;

use Direct::Model::BannerImageAd::Constants;

extends 'Direct::Model::Banner';

# TODO DIRECT-67003 похоже эта штука + поле image_url - про загрузку из XLS
# with 'Direct::Model::BannerImage::Role::Url';


__PACKAGE__->_setup(
    default_table  => 'banners',
    manager_class  => __PACKAGE__.'::Manager',

    relations => [
        image_ad => { type => 'Direct::Model::Image' },
    ],
);

sub BUILD {
    my ($self) = @_;
    $self->_set_attr_raw_value(body => $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER);
    $self->_set_attr_raw_value(title => $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER);
}

has '+banner_type'          => (isa => enum(['mcbanner']), lazy => 0, builder => sub { 'mcbanner' });
has '+title'                => (is => 'ro', builder => sub { $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER });
has '+title_extension'      => (isa => 'Undef', builder => sub { undef });
has '+body'                 => (is => 'ro', builder => sub { $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER } );
has '+is_mobile'            => (isa => 'OnlyFalse', builder => sub { 0 });
has '+vcard_id'             => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id'     => (isa => 'Undef', builder => sub { undef });
has '+image_hash'           => (isa => 'Undef', builder => sub { undef });

has '+vcard'                => (isa => 'Undef');
has '+sitelinks_set'        => (isa => 'Undef');
has '+additions_callouts'   => (isa => 'Undef');
has '+image'                => (isa => 'Undef');

has '+adgroup'              => (isa => 'Direct::Model::AdGroupMcbanner');

#TODO DIRECT-67003 что это и зачем? похоже относится к Direct::Model::BannerImage::Role::Url
# sub _build_url {
#     my $self = shift;
#     croak sprintf('Banner %s: Url must be setted before using!', $self->id);
# }

sub get_name {
    my $self = shift;
    return $self->image_ad->get_name();
}

sub get_width {
    my $self = shift;
    return $self->image_ad->get_width();
}

sub get_height {
    my $self = shift;
    return $self->image_ad->get_height();
}

sub get_preview_url {
    my $self = shift;
    return $self->image_ad->get_preview_url();
}

sub get_scale_size {
    my $self = shift;
    return $self->image_ad->get_scale_size();
}

sub detect_lang {
    my $self = shift;
    return 'ru';    # copied from Direct::Banners::ImageAd->detect_lang()
}

sub to_template_hash {
    my $self = shift;
    return {
        name => $self->get_name(),
        width => $self->get_width(),
        height => $self->get_height(),
        preview_url => $self->get_preview_url(),
        scale => $self->get_scale_size(),
        image_ad => $self->image_ad->to_template_hash(),
    };
}

sub is_title_supported { 0 }
sub is_body_supported { 0 }
sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub is_image_supported { 0 }
sub is_imagead_supported { 1 }

sub adgroup_class { 'Direct::Model::AdGroupMcbanner' }

1;

