package Direct::Model::BannerMcbanner::Manager;

use Direct::Modern;

use Mouse;

extends 'Direct::Model::Banner::Manager';

use Settings;

use Direct::Model::BannerMcbanner;
use Direct::Model::Image::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerMcbanner]');

=head2 _create_in_shard($shard, $banners)

Внутренний метод.
Создание в БД в определённом шарде записей для соответствующих объектов

=cut

sub _create_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_create_in_shard($shard, $banners);
    my @images = map { $_->image_ad } @$banners;
    Direct::Model::Image::Manager->new(items => \@images)->create();

    return;
}

=head2 _update_in_shard($shard, $banners, %options)

Внутренний метод.
Обновление в БД в определённом шарде записей для соответствующих объектов.

=cut

sub _update_in_shard {
    my ($self, $shard, $banners, %options) = @_;
    $self->SUPER::_update_in_shard($shard, $banners, %options);
    my @images = map { $_->image_ad } @$banners;
    Direct::Model::Image::Manager->new(items => \@images)->update();

    return;
}

=head2 _delete_in_shard($shard, $banners)

Внутренний метод.
Удаление из БД в определённом шарде записей для соответствующих объектов.

=cut

sub _delete_in_shard {
    my ($self, $shard, $banners) = @_;
    $self->SUPER::_delete_in_shard($shard, $banners);

    return;
}

__PACKAGE__->meta->make_immutable;

1;

