package Direct::Model::BannerMobileContent;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Banner';
with 'Direct::Model::Role::Banner::WithVideoAddition';

#
# Баннер мобильного контента: отсутствуют картинка, сайтлинки, визитка
#

__PACKAGE__->_setup(
    default_table  => 'banners_mobile_content',
    manager_class  => __PACKAGE__.'::Manager',
    
    relations => [
        creative => { type => 'Maybe[Direct::Model::BannerCreative]' },
    ],

    fields => [
        reflected_attrs => { type => 'Set', values => [qw/rating price icon rating_votes/] },
        primary_action  => {
            type => 'Enum',
            values => [qw/download get install more open update play buy/],
            default => 'download',
        },
    ],
    
    state_flags => [qw/
        moderate_creative
        delete_video_addition_from_moderation
    /],
);

has '+banner_type'      => (isa => enum(['mobile_content']), lazy => 0, builder => sub { 'mobile_content' });
has '+title_extension'  => (isa => 'Undef', builder => sub { undef });
has '+vcard_id'         => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id' => (isa => 'Undef', builder => sub { undef });

has '+adgroup'       => (isa => 'Direct::Model::AdGroupMobileContent');
has '+vcard'         => (isa => 'Undef');
has '+sitelinks_set' => (isa => 'Undef');
has '+is_mobile'     => (isa => 'OnlyFalse', builder => sub { 0 });

sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub adgroup_class { 'Direct::Model::AdGroupMobileContent' }

1;
