package Direct::Model::BannerMobileContent::Manager;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::Banner::Manager';

use Settings;

use Yandex::DBTools;

use Direct::Model::BannerMobileContent;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerMobileContent]');

=head2 _create_in_shard($shard, $banners)

Внутренний метод.
Создание в БД в определённом шарде записей для соответствующих объектов (РМП объявлений).

=cut

sub _create_in_shard {
    my ($self, $shard, $banners) = @_;

    my @columns = Direct::Model::BannerMobileContent->get_db_columns_list('banners_mobile_content');

    do_in_transaction {
        # Создадим базовые баннеры
        $self->SUPER::_create_in_shard($shard, $banners);

        $self->_insert_to_secondary_table_in_db(PPC(shard => $shard), 'banners_mobile_content', banners => 'bid', \@columns, $banners);
    };
    
    $self->_do_moderate_creatives($shard, $banners);
    $self->_save_banner_creatives($shard, $banners);
    $self->_do_update_video_resources($shard, $banners);

    return;
}

=head2 _update_in_shard($shard, $banners, %options)

Внутренний метод.
Обновление в БД в определённом шарде записей для соответствующих объектов (РМП объявлений).

=cut

sub _update_in_shard {
    my ($self, $shard, $banners, %options) = @_;

    do_in_transaction {
        # Обновим базовые баннеры
        $self->SUPER::_update_in_shard($shard, $banners, %options);

        $self->_update_one_table_in_db(PPC(shard => $shard), banners_mobile_content => 'bid', $banners);
    };
    
    $self->_do_moderate_creatives($shard, $banners);
    $self->_save_banner_creatives($shard, $banners);
    $self->_do_update_video_resources($shard, $banners);

    return;
}

sub _delete_in_shard { croak "Unimplemented!"; }

sub _do_check_redirect {
    my ($self, $shard, $banners) = @_;
    return;
}

sub _do_update_filter_domain {
    my ($self, $shard, $banners) = @_;
    return;
}


__PACKAGE__->meta->make_immutable;

1;
