package Direct::Model::BannerPerformance;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::I18n;

extends 'Direct::Model::Banner';

__PACKAGE__->_setup(
    default_table  => 'banners_performance',
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        banner_creative_id  => { type => 'Id' },
        creative_id         => { type => 'Id' },
        creative_status_moderate     => {
            type => 'Enum',
            values => [qw/Yes No Sent Sending Ready New/],
            column => 'statusModerate',
            alias => 'bc_statusModerate',
            default => 'New',
        },
    ],

    relations => [
        creative    => { type => 'Direct::Model::Creative' },
    ],

    state_flags => [qw/
        set_geo_for_new_creative
        moderate_creative
        set_adgroup_bl_status
    /],
);

sub BUILD {
    my ($self) = @_;
    $self->_set_attr_raw_value(body => iget('{Перфоманс текст}'));
    $self->_set_attr_raw_value(title => iget('{Перфоманс заголовок}'));
}

has '+banner_type'      => (isa => enum(['performance', 'performance_main']), lazy => 0, builder => sub { 'performance' });
has '+title'            => (is => 'ro');
has '+title_extension'  => (isa => 'Undef', builder => sub { undef });
has '+body'             => (is => 'ro');
has '+is_mobile'        => (isa => 'OnlyFalse', builder => sub { 0 });
has '+href'             => (isa => 'Undef', builder => sub { undef });
has '+domain_id'        => (isa => 'Undef', builder => sub { undef });
has '+domain'           => (isa => 'Undef', builder => sub { undef });
has '+reverse_domain'   => (isa => 'Undef', builder => sub { undef });

has '+image_hash'       => (isa => 'Undef', builder => sub { undef });
has '+vcard_id'         => (isa => 'Undef', builder => sub { undef });
has '+sitelinks_set_id' => (isa => 'Undef', builder => sub { undef });

has '+adgroup'       => (isa => 'Direct::Model::AdGroupPerformance');
has '+image'         => (isa => 'Undef');
has '+vcard'         => (isa => 'Undef');
has '+sitelinks_set' => (isa => 'Undef');

sub is_title_supported { 0 }
sub is_body_supported { 0 }
sub is_href_supported { 0 }
sub is_vcard_supported { 0 }
sub is_sitelinks_set_supported { 0 }
sub is_image_supported { 0 }
sub adgroup_class { 'Direct::Model::AdGroupPerformance' }

1;
