package Direct::Model::BannerPlacementPage;

use Direct::Modern;

use Mouse;

use Yandex::HashUtils qw/hash_cut/;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table => 'moderate_banner_pages',

    fields => [
        id              => { type => 'Id', column => 'moderate_banner_page_id', primary_key => 1 },
        banner_id       => { type => 'Id', column => 'bid' },
        page_id         => { type => 'Id', column => 'PageID' },
        version         => { type => 'Id', column => 'version' },
        comment         => { type => 'Maybe[Str]', column => 'comment' },
        is_removed      => { type => 'Bool', default => 0 },
        status_moderate => { type => 'Enum', values => [ qw/Yes No Sent Sending Ready New Maybe/ ], column => 'statusModerate', default => 'New', volatile => 1 },
        status_moderate_operator => { type => 'Enum', values => [ qw/Yes No None/ ], column => 'statusModerateOperator', default => 'New', volatile => 1 },
    ],
);

sub to_template_hash {
    my ($self) = @_;

    my $hash = $self->SUPER::to_hash();
    $hash = hash_cut $hash, qw/id banner_id page_id version status_moderate status_moderate_operator/;
    $hash->{moderate_banner_page_id} = delete $hash->{id};

    return $hash;
}

1;
