package Direct::Model::BannerPrice;

use Direct::Modern;

use Mouse;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table => 'banner_prices',

    fields => [
        banner_id       => {type => 'Id', column => 'bid', primary_key => 1},
        prefix          => {type => 'Maybe[Enum]', values => [qw/from to/] },
        price           => {type => 'Num'},
        price_old       => {type => 'Maybe[Num]'},
        currency        => {type => 'Enum', values => [qw/RUB UAH BYN USD EUR KZT TRY CHF UZS/] },
    ],
);

sub to_template_hash {
    
    my $self = shift;
    
    return {
	prefix => $self->{prefix} ? uc($self->{prefix}) : "",
	price => $self->{price},
	priceOld => $self->{price_old} // "",
	currency => $self->{currency},
    }
}

1;
