package Direct::Model::BannerText;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;
use List::Util qw/first/;

extends 'Direct::Model::Banner';
with 'Direct::Model::Role::Banner::WithVideoAddition';

#
# Текстовый баннер: сохраняет все свойства базового баннера
#

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        permalink => {
            type   => 'Maybe[Id]',
            table  => 'banner_permalinks',
            column => 'permalink',
        }
    ],

    relations => [
        creative => { type => 'Maybe[Direct::Model::BannerCreative]' },
    ],
    
    state_flags => [qw/
        moderate_creative
    /],
);

has '+banner_type' => (isa => enum(['text']), lazy => 0, builder => sub { 'text' });
has '+title_extension' => (isa => 'Maybe[Str]', builder => sub { undef });

sub is_callouts_supported { 1 }
sub adgroup_class { 'Direct::Model::AdGroupText' }

sub is_display_href_supported { 1 }
sub is_title_extension_supported { 1 }
sub is_turbolanding_supported { 1 }
sub is_permalink_supported { 1 }

1;
