package Direct::Model::Bid;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Helpers qw/mysql_timestamp_around/;

use Direct::Model::Keyword::BsData;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';

our @BID_TYPES = qw/keyword relevance_match relevance_match_search/;

__PACKAGE__->_setup(
    default_table => 'bids_base',

    fields        => [
        id                  => { type => 'Id64', column => 'bid_id', primary_key => 1 },
        adgroup_id          => { type => 'Id', column => 'pid' },
        campaign_id         => { type => 'Id', column => 'cid' },
        bid_type            => { type => 'Enum', values => \@BID_TYPES, column => 'bid_type', default => 'keyword' },
        price               => { type => 'Num', default => '0.00' },
        price_context       => { type => 'Num', default => '0.00' },
        autobudget_priority => { type => 'Maybe[Int]', column => 'autobudgetPriority' },
        last_change         => { type => 'Timestamp', column => 'LastChange' },
        status_bs_synced    => { type => 'Enum', values => [ qw/No Sending Yes/ ], column => 'statusBsSynced', default => 'No', volatile => 1 },

        _opts               => { type => 'Str', column => 'opts', default => '' },
    ],

    additional  =>   [
        is_suspended      => { type => 'Bool', track_changes => 1, trigger => \&_on_opts_flag_changed },
        is_deleted        => { type => 'Bool', track_changes => 1, trigger => \&_on_opts_flag_changed },
    ],

    relations     => [
        adgroup => { type => 'Direct::Model::AdGroup' },
    ],

    state_flags   => [ qw/bs_sync_adgroup moderate_adgroup update_adgroup_last_change/ ],
);


# Allow set to `now`
around last_change => mysql_timestamp_around('last_change');

around from_db_hash => sub {
        my ($orig, $class) = (shift, shift);
        my ($row, $cache, %options) = @_;
        
        if (defined $row->{bid_type} && $row->{bid_type} eq 'relevance_match_search') {
                $row->{bid_type} = 'relevance_match';
        }
        
        $class->$orig($row, $cache, %options);
    };

around BUILDARGS => sub {
        my ($orig, $class) = (shift, shift);
        my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;

        if (defined $args{_opts}) {
            $args{is_suspended} //= scalar($args{_opts} =~ /\bsuspended\b/);
            $args{is_deleted} //= scalar($args{_opts} =~ /\bdeleted\b/);
        }

        $class->$orig(%args);
    };

sub _on_opts_flag_changed {
    my ($self, $new) = @_;

    return if !$self->_constructed && $self->_has_opts;

    my @flags;
    push @flags, 'suspended'   if $self->has_is_suspended && $self->is_suspended;
    push @flags, 'deleted'     if $self->has_is_deleted && $self->is_deleted;
    $self->_opts(join ',' => @flags);

    return;
}

sub to_template_hash {
    my $hash = shift->to_hash;
    $hash->{bid_id} = delete $hash->{id};
    $hash->{autobudgetPriority} = delete $hash->{autobudget_priority} if exists $hash->{autobudget_priority};
    return $hash;
}

1;
