package Direct::Model::Bid::Manager;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;

use Yandex::DBTools;

use Direct::Model::Bid;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::Bid]');

sub _do_update_adgroups {
    my ($self, $shard, $bids) = @_;

    my %update_adgroups;
    for my $bid (@$bids) {
        # Отправка группы в БК
        if ($bid->do_bs_sync_adgroup) {
            $update_adgroups{$bid->adgroup_id}->{statusBsSynced} = sql_quote('No');
            $update_adgroups{$bid->adgroup_id}->{LastChange} = 'LastChange';
        }

        # Отправка группы на Модерацию
        if ($bid->do_moderate_adgroup) {
            $update_adgroups{$bid->adgroup_id}->{statusModerate} = sql_quote('Ready');
            $update_adgroups{$bid->adgroup_id}->{statusPostModerate} = "IF(statusPostModerate = 'Rejected', 'Rejected', 'No')";
            $update_adgroups{$bid->adgroup_id}->{LastChange} = 'LastChange';
        }

        # Изменение времени модификации группы (важно, чтобы условие было в конце)
        if ($bid->do_update_adgroup_last_change) {
            $update_adgroups{$bid->adgroup_id}->{LastChange} = 'NOW()';
        }
    }

    my %byfield_options;
    $byfield_options{$_} = { default__dont_quote => $_, dont_quote_value => 1 } for map { keys %$_ } values %update_adgroups;

    do_mass_update_sql(PPC(shard => $shard), 'phrases', 'pid', \%update_adgroups, byfield_options => \%byfield_options);

    return;
}

__PACKAGE__->meta->make_immutable;

1;
