package Direct::Model::BidRelevanceMatch;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Bid';

our $BID_TYPE = 'relevance_match';


#
# Беcфразный таргетинг. Условие показа баннера на поиске без ключевой фразы
#

__PACKAGE__->_setup(
    manager_class => __PACKAGE__.'::Manager',

    fields        => [

        # href_params
        href_param1 => { type => 'Maybe[Str]', table => 'bids_href_params', column => 'param1', length => 255 },
        href_param2 => { type => 'Maybe[Str]', table => 'bids_href_params', column => 'param2', length => 255 },
    ],
);

has '+bid_type' => (isa => enum([ $BID_TYPE ]), lazy => 0, builder => sub { $BID_TYPE });

1;
