package Direct::Model::BrandSafetyCondition;

use Direct::Modern;
use Yandex::ListUtils qw/nsort/;
use Mouse;
use Mouse::Util::TypeConstraints;
use JSON;
use Carp qw/croak/;

use Direct::Model::RetargetingCondition::Goal;
use Direct::Model::RetargetingCondition::Rule;

extends 'Direct::Model::RetargetingCondition';

has '+retargeting_conditions_type' => (isa => enum(['brandsafety']), lazy => 0, builder => sub { 'brandsafety' });
has '+condition_name'              => (is => 'ro', builder => sub { 'brandsafety condition' } );
has '+condition_desc'              => (is => 'ro', builder => sub { 'brandsafety categories' } );

around BUILDARGS => sub {
    my ($orig, $class) = (shift, shift);
    my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;

    if (defined $args{category_ids}) {
        my $ids = delete $args{category_ids};
        my $goals = [map {
            Direct::Model::RetargetingCondition::Goal->new(goal_id => $_, goal_type => 'brandsafety', time => 0)
        } nsort @$ids];
        $args{condition} = [Direct::Model::RetargetingCondition::Rule->new(type => 'not', goals => $goals)];
    }

    if (defined $args{_condition_json}) {
        eval { $args{condition} = JSON->new->utf8(0)->decode($args{_condition_json}); 1; } or do { croak "Cannot apply `condition_json`: $@"; };
    }

    $class->$orig(%args);
};

sub BUILD {
    my ($self) = @_;
    $self->_set_attr_raw_value(condition_name => 'brandsafety condition' );
    $self->_set_attr_raw_value(condition_desc => 'brandsafety categories' );
}


1;
