package Direct::Model::CampaignContentPromotion;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;
use Yandex::ORM::Types;

extends 'Direct::Model::Campaign';

has '+campaign_type' => (isa => enum(['content_promotion']), lazy => 0, builder => sub { 'content_promotion' });
has '+platform' => (isa => enum(['search']), lazy => 0, builder => sub { 'search' });

has '+_disabled_ssp'            => (isa => 'Maybe[Str]', builder => sub { '[]' });
has '+disabled_domains'         => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+competitors_domains'      => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+fair_auction'             => (isa => enum(['No']), builder => sub { 'No' });


has '+_strategy_name' => (
        isa => maybe_type(enum(['', qw/
            default
            autobudget_avg_cpc_per_camp
            autobudget
            autobudget_avg_click
            autobudget_week_bundle
        /])),
        lazy => 0,
        builder => sub { '' },
    );

override supported_type => sub {'content_promotion'};

override get_strategy_app_hash => sub {
    my $self = shift;
    my ($strategy, %O) = @_;
    $strategy ||= $self->get_strategy;

    return {
        name => $strategy->name,
        is_autobudget => $strategy->_as_num($strategy->is_autobudget),
        is_search_stop => 0,
        is_net_stop => 1,
        search => $strategy->get_strategy_hash(),
        net => { name => 'stop' }
    };
};

1;
