package Direct::Model::CampaignCpmBanner;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Campaign';

has '+campaign_type' => (isa => enum(['cpm_banner']), lazy => 0, builder => sub { 'cpm_banner' });
has '+platform' => (isa => enum(['context']), lazy => 0, builder => sub { 'context' });

override supported_type => sub {'cpm_banner'};

override available_creative_types => sub {[qw/canvas html5_creative video_addition/]};

override get_strategy_app_hash => sub {
    my $self = shift;
    my ($strategy, %O) = @_;
    $strategy ||= $self->get_strategy;

    return {
        name => 'different_places',
        is_autobudget => $strategy->_as_num($strategy->is_autobudget),
        is_search_stop => 1,
        is_net_stop => 0,
        search => { name => 'stop' },
        net => $strategy->get_strategy_hash()
    };
};

1;

