package Direct::Model::CampaignCpmDeals;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    additional => [
        is_yandex_page => { type => 'Maybe[Bool]' },
    ],
);

has '+campaign_type' => (isa => enum(['cpm_deals']), lazy => 0, builder => sub { 'cpm_deals' });
has '+platform' => (isa => enum(['context']), lazy => 0, builder => sub { 'context' });

override supported_type => sub {'cpm_deals'};

override available_creative_types => sub {[qw/canvas html5_creative/]};

override get_strategy_app_hash => sub {
        my $self = shift;
        my ($strategy, %O) = @_;
        $strategy ||= $self->get_strategy;

        return {
            name => 'different_places',
            is_autobudget => $strategy->_as_num($strategy->is_autobudget),
            is_search_stop => 1,
            is_net_stop => 0,
            search => { name => 'stop' },
            net => $strategy->get_strategy_hash()
        };
    };

1;
