package Direct::Model::CampaignCpmPrice;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;
use Yandex::ORM::Types;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    default_table  => 'campaigns_cpm_yndx_frontpage',

    fields => [
        allowed_frontpage_types => { type => 'Maybe[Set]', values => ['','frontpage','frontpage_mobile','browser_new_tab'] , default => '' },
    ],
);

has '+campaign_type' => (isa => enum(['cpm_price']), lazy => 0, builder => sub { 'cpm_price' });
has '+platform' => (isa => enum(['context']), lazy => 0, builder => sub { 'context' });

has '+_disabled_ssp'            => (isa => 'Maybe[Str]', builder => sub { '[]' });
has '+disabled_domains'         => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+competitors_domains'      => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+fair_auction'             => (isa => enum(['No']), builder => sub { 'No' });

has '+strategy_name' => (
    isa => enum(['', qw/
        cpm_default
        period_fix_bid
    /]),
    lazy => 0,
    builder => sub { '' },
);

override supported_type => sub {'cpm_price'};

override available_creative_types => sub {[qw/html5_creative/]};

override get_strategy_app_hash => sub {
    my $self = shift;
    my ($strategy, %O) = @_;
    $strategy ||= $self->get_strategy;

    return {
        name => 'different_places',
        is_autobudget => 0,
        is_search_stop => 1,
        is_net_stop => 0,
        search => { name => 'stop' },
        net => $strategy->get_strategy_hash()
    };
};

1;
