package Direct::Model::CampaignCpmYndxFrontpage;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;
use Yandex::ORM::Types;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    default_table  => 'campaigns_cpm_yndx_frontpage',

    fields => [
        allowed_frontpage_types => { type => 'Set', values => ['frontpage','frontpage_mobile','browser_new_tab'] },
    ],
);

has '+campaign_type' => (isa => enum(['cpm_yndx_frontpage']), lazy => 0, builder => sub { 'cpm_yndx_frontpage' });
has '+platform' => (isa => enum(['context']), lazy => 0, builder => sub { 'context' });

has '+broad_match_flag'         => (isa => enum(['No']), builder => sub { 'No' });
has '+broad_match_limit'        => (isa => 'Zero', builder => sub { 0 });
has '+broad_match_goal_id'      => (isa => 'Maybe[Zero]', builder => sub { 0 });
has '+_disabled_ssp'            => (isa => 'Maybe[Str]', builder => sub { '[]' });
has '+hierarchical_multipliers' => (isa => 'Undef', builder => sub { undef });
has '+minus_words'              => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+disabled_domains'         => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+competitors_domains'      => (isa => 'EmptyArrayRef', builder => sub { [] });
has '+fair_auction'             => (isa => enum(['No']), builder => sub { 'No' });

has '+strategy_name' => (
        isa => enum(['', qw/
            cpm_default
            autobudget_max_impressions
            autobudget_max_reach
            autobudget_max_impressions_custom_period
            autobudget_max_reach_custom_period
        /]),
        lazy => 0,
        builder => sub { '' },
    );

override supported_type => sub {'cpm_yndx_frontpage'};

override available_creative_types => sub {[qw/canvas html5_creative video_addition/]}; #?

override get_strategy_app_hash => sub {
    my $self = shift;
    my ($strategy, %O) = @_;
    $strategy ||= $self->get_strategy;

    return {
        name => 'different_places',
        is_autobudget => $strategy->_as_num($strategy->is_autobudget),
        is_search_stop => 1,
        is_net_stop => 0,
        search => { name => 'stop' },
        net => $strategy->get_strategy_hash()
    };
};

1;
