package Direct::Model::CampaignCpmYndxFrontpage::Manager;

use Direct::Modern;

use Mouse;

use Direct::Model::CampaignCpmYndxFrontpage;

use Settings;

use Yandex::DBTools;

extends 'Direct::Model::Campaign::Manager';

has '+items' => (isa => 'ArrayRef[Direct::Model::CampaignCpmYndxFrontpage]');

=head2 _create_in_shard($shard, $campaigns)

    Внутренний метод.
    Создание в БД в определённом шарде записей для соответствующих объектов (кампаний Охватный продукт на Главной).

=cut

sub _create_in_shard {
    my ( $self, $shard, $campaigns ) = @_;

    my @columns = Direct::Model::CampaignCpmYndxFrontpage->get_db_columns_list('campaigns_cpm_yndx_frontpage');

    do_in_transaction {

        $self->SUPER::_create_in_shard( $shard, $campaigns );

        $self->_insert_to_secondary_table_in_db( PPC( shard => $shard ), 'campaigns_cpm_yndx_frontpage', campaigns => 'cid', \@columns, $campaigns );
    };

    return;
}

=head2 _update_in_shard($shard, $campaigns)

    Внутренний метод.
    Обновление в БД в определённом шарде записей для соответствующих объектов (кампаний Охватный продукт на Главной).

=cut

sub _update_in_shard {
    my ( $self, $shard, $campaigns ) = @_;

    do_in_transaction {
 
        $self->SUPER::_update_in_shard( $shard, $campaigns );

        $self->_update_one_table_in_db( PPC( shard => $shard ), campaigns_cpm_yndx_frontpage => 'cid', $campaigns );
    };

    return;
}

1;

