package Direct::Model::CampaignInternalDistrib;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    default_table => 'campaigns_internal',

    fields => [
        is_mobile => {
            type => 'Bool',
            column => 'is_mobile',
            default => 0},
        restriction_type => {
            type => 'Maybe[Enum]',
            column => 'restriction_type',
            values => [qw/money/]},
        page_ids => {
            type => 'Maybe[Str]',
            column => 'page_ids'},
        place_id => {
            type => 'Int',
            column =>'place_id'},
        rotation_goal_id => {
            type => 'Id',
            column => 'rotation_goal_id'},
    ],
);

has '+campaign_type' => ( isa => enum(['internal_distrib']), lazy => 0, builder => sub { 'internal_distrib' });

override supported_type => sub {'internal_distrib'};

1;
