package Direct::Model::CampaignInternalDistrib::Manager;

use Direct::Modern;

use Mouse;

use Settings;
use Direct::Model::CampaignInternalDistrib;

extends 'Direct::Model::Campaign::Manager';

has '+items' => (isa => 'ArrayRef[Direct::Model::CampaignInternalDistrib]');

override _update_in_shard => sub {
    my $self = shift;
    my ($shard, $camps) = @_;

    super();
    $self->_update_one_table_in_db(PPC(shard => $shard), campaigns_internal => 'cid', $camps);

    return;
};

override _create_in_shard  => sub {
    my ( $self, $shard, $campaigns ) = @_;

    my @columns = Direct::Model::CampaignInternalDistrib->get_db_columns_list('campaigns_internal');

    do_in_transaction {
        # Создадим базовые группы
        $self->SUPER::_create_in_shard( $shard, $campaigns );

        $self->_insert_to_secondary_table_in_db( PPC( shard => $shard ), 'campaigns_internal', campaigns => 'cid', \@columns, $campaigns);
    };

    return;
};

__PACKAGE__->meta->make_immutable;

1;
