package Direct::Model::CampaignInternalFree;
use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    default_table => 'campaigns_internal',

    fields => [
        is_mobile => {
            type => 'Bool',
            column => 'is_mobile',
            default => 0},
        restriction_type => {
            type => 'Maybe[Enum]',
            column => 'restriction_type',
            values => [qw/shows clicks days/]},
        restriction_value => {
            type => 'Int',
            column => 'counter_type_value',
            default => 0},
        page_ids => {
            type => 'Maybe[Str]',
            column => 'page_ids'},
        place_id => {
            type => 'Int',
            column =>'place_id'},
    ],
);

has '+campaign_type' => ( isa => enum(['internal_free']), lazy => 0, builder => sub { 'internal_free' });

override supported_type => sub {'internal_free'};

1;
