package Direct::Model::CampaignMobileContent;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    default_table  => 'campaigns_mobile_content',

    fields => [
        is_installed_app      => { type => 'Bool' },

        device_type_targeting => { type => 'Set', values => [qw/phone tablet/] },
        network_targeting     => { type => 'Set', values => [qw/wifi cell/] },
    ],
);

has '+campaign_type' => (isa => enum(['mobile_content']), lazy => 0, builder => sub { 'mobile_content' });

override supported_type => sub {'mobile_content'};

override available_creative_types => sub {[qw/canvas html5_creative video_addition/]};

1;
