package Direct::Model::CampaignMobileContent::Manager;

use Direct::Modern;

use Mouse;

use Direct::Model::CampaignMobileContent;

use Settings;

use Yandex::DBTools;

extends 'Direct::Model::Campaign::Manager';

has '+items' => (isa => 'ArrayRef[Direct::Model::CampaignMobileContent]');

=head2 _create_in_shard($shard, $campaigns)

    Внутренний метод.
    Создание в БД в определённом шарде записей для соответствующих объектов (кампаний РМП).

=cut

sub _create_in_shard {
    my ( $self, $shard, $campaigns ) = @_;

    my @columns = Direct::Model::CampaignMobileContent->get_db_columns_list('campaigns_mobile_content');

    do_in_transaction {
        # Создадим базовые группы
        $self->SUPER::_create_in_shard( $shard, $campaigns );

        $self->_insert_to_secondary_table_in_db( PPC( shard => $shard ), 'campaigns_mobile_content', phrases => 'pid', \@columns, $campaigns );
    };

    return;
}

=head2 _update_in_shard($shard, $campaigns)

    Внутренний метод.
    Обновление в БД в определённом шарде записей для соответствующих объектов (кампаний РМП).

=cut

sub _update_in_shard {
    my ( $self, $shard, $campaigns ) = @_;

    do_in_transaction {
        # Обновим базовые группы
        $self->SUPER::_update_in_shard( $shard, $campaigns );

        $self->_update_one_table_in_db( PPC( shard => $shard ), campaigns_mobile_content => 'pid', $campaigns );
    };

    return;
}

1;
