package Direct::Model::CampaignPerformance;
use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::Campaign';

__PACKAGE__->_setup(
    default_table => 'campaigns_performance',

    fields => [
        now_optimizing_by  => { type => 'Enum', values => [qw/CPC CPA/], default => 'CPC' },
    ],
);

has '+campaign_type' => ( isa => enum(['performance']), lazy => 0, builder => sub { 'performance' });

has '+_strategy_name' => (
        isa => maybe_type(enum(['', qw/
            autobudget_avg_cpc_per_camp
            autobudget_avg_cpc_per_filter
            autobudget_avg_cpa_per_camp
            autobudget_avg_cpa_per_filter
            autobudget
            autobudget_roi
            autobudget_crr
        /])),
        lazy => 0,
        builder => sub { 'autobudget_avg_cpc_per_camp' },
    );


override supported_type => sub {'performance'};

around 'from_db_hash' => sub {
    my ($orig, $self, $db_hash, @another_args) = @_;
    delete $db_hash->{now_optimizing_by} if exists $db_hash->{now_optimizing_by} && !(defined $db_hash->{now_optimizing_by});

    return $self->$orig($db_hash, @another_args);
};

1;
