package Direct::Model::CampaignPerformance::Manager;
use Direct::Modern;
use Mouse;

extends 'Direct::Model::Campaign::Manager';

use Direct::PerformanceFilters;

use Settings;


has '+items' => (isa => 'ArrayRef[Direct::Model::CampaignPerformance]');


override _update_in_shard => sub {
    my $self = shift;
    my ($shard, $camps) = @_;

    my @cids_to_reset_filters;
    for my $camp (@{$self->items}) {
        push @cids_to_reset_filters, $camp->id  if $camp->_is_strategy_name_changed;
    }

    super();
    $self->_update_one_table_in_db(PPC(shard => $shard), campaigns_performance => 'cid', $camps);

    $self->_do_resend_filters(\@cids_to_reset_filters)  if @cids_to_reset_filters;

    return;
};


sub _do_resend_filters {
    my $self = shift;
    my ($cids) = @_;

    my $filter_manager = Direct::PerformanceFilters->get_by(campaign_id => $cids);
    my $filters = $filter_manager->items();
    return if !@$filters;

    for my $filter (@$filters) {
        $filter->status_bs_synced("No");
    }

    $filter_manager->update();

    return;
}



__PACKAGE__->meta->make_immutable;
1;
