package Direct::Model::CanvasCreative;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;
use JSON;

use Lang::Guess qw/analyze_text_lang/;
use List::MoreUtils qw/any/;

use Direct::Model::CanvasCreativeScales;

extends 'Direct::Model::Creative';

# Ключи должны быть аналогичны тегам из SessionParams канваса
our %COMPATIBLE_LAYOUT_IDS = (
    cpm_geoproduct => [10 .. 19],
);

our %CANVAS_TAGS = (
    cpm_geoproduct => 'cpm_geoproduct',
);

has '+creative_type'       => (isa => enum([qw/canvas/]), lazy => 0, builder => sub { 'canvas' });
has '+template_id'         => (isa => 'Undef');
has '+template_name'       => (isa => 'Undef', lazy => 0, builder => sub { undef });
has '+layout_id'           => (isa => 'Maybe[Int]');
has '+layout'              => (isa => 'Undef', lazy => 0, builder => sub { undef });
has '+preview_scale'       => (lazy => 0, builder => sub { 0.5 });
has '+_additional_data'    => (isa => 'Undef');

sub detect_lang {
    my $self = shift;
    my $info = $self->moderate_info;
    return analyze_text_lang(map { $_->{text} } @{$info->{texts} || []}) || 'ru';
}

sub to_template_hash {
    my $self = shift;

    my $hash = $self->to_hash;
    $hash->{rejection_reason_ids} = [];
    $hash->{creative_id} = delete $hash->{id};
    $hash->{bs_template_name} = undef;
    $hash->{creative_text} = join ' ', map { $_->{text} } @{$self->moderate_info->{texts} || []};
    $hash->{scale} = $self->get_scale_size();
    $hash->{canvas_tags} = $self->get_canvas_tags();
    return $hash;
}

sub get_scale_size {
    my $self = shift;
    return Direct::Model::CanvasCreativeScales::size2scale($self->width . 'x' . $self->height);
}

sub moderate_info {
    my $self = shift;
    if (@_) {
        my $moderate_info = shift;
        $self->_moderate_info(defined $moderate_info ? JSON->new->utf8(0)->encode($moderate_info) : undef);
        return $moderate_info;
    } 

    return {} unless $self->_moderate_info;
    return JSON->new->utf8(0)->decode($self->_moderate_info);
}

sub get_canvas_tags {
    my $self = shift;
    my @result;
    foreach my $key (keys %COMPATIBLE_LAYOUT_IDS) {
        if (any {$_ eq ($self->layout_id // '')} @{$COMPATIBLE_LAYOUT_IDS{$key}}) {
            push @result, $CANVAS_TAGS{$key};
        }
    }
    return \@result;
}

1;
