package Direct::Model::CanvasCreativeScales;

use Direct::Modern;

# copy from ImageFormat
my %SIZE2SCALE = (
    '240x600' => 0.5,
    '300x250' => 0.8,
    '300x300' => 0.5,
    '300x500' => 0.5,
    '300x600' => 0.5,
    '320x480' => 0.5,
    '336x280' => 0.7,
    '480x320' => 0.5,
    '640x200' => 0.35,
    '640x960' => 0.35,
    '640x100' => 0.35,
    '640x134' => 0.35,
    '728x90'  => 0.3,
    '960x640' => 0.25,
    '970x250' => 0.2,
    '1000x120' => 0.35,
    '1456x180' => 0.15,
);

sub size2scale {
    my ($size) = @_;
    return $SIZE2SCALE{$size} // 0.5;
}

1;

__END__
