package Direct::Model::Client;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'clients',

    fields => [
        id                        => { type => 'Id', column => 'ClientID', primary_key => 1 },
        client_name               => { type => 'Maybe[Str]', column => 'name', length => 255 },
        work_currency             => { type => 'Maybe[Enum]', values => [qw/RUB UAH KZT USD EUR YND_FIXED CHF TRY BYN GBP/] },
        create_date               => { type => 'Timestamp' },
        role                      => { type => 'Str', column => 'role' },
        chief_uid                 => { type => 'Maybe[Int]' },

        # ...

        # client_limits
        campaigns_limit            => { type => 'Int', table => 'client_limits', column => 'camp_count_limit', default => 0 },
        unarch_campaigns_limit     => { type => 'Int', table => 'client_limits', column => 'unarc_camp_count_limit', default => 0 },
        adgroups_limit             => { type => 'Int', table => 'client_limits', column => 'banner_count_limit', default => 0 },
        keywords_limit             => { type => 'Int', table => 'client_limits', column => 'keyword_count_limit', default => 0 },
        video_blacklist_size_limit => { type => 'Int', table => 'client_limits', column => 'video_blacklist_size_limit', default => 0 },
    ],

    relations => [
        chief_rep           => { type => 'Direct::Model::User' },
    ],
    additional => [
        permitted_pixel_providers => { type => 'HashRef' },
    ],
);

1;
