package Direct::Model::ClientClient;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::Client';

__PACKAGE__->_setup(
    relations => [
        agency_relations    => { type => 'ArrayRef[Direct::Model::AgencyClientRelation]' },
        managers            => { type => 'ArrayRef[Direct::Model::ManagerClient]' },
    ]
);

sub get_agencies() {
    my ($self) = @_;

    return [ map { $_->agency() } @{$self->agency_relations()} ];
}

1;
