package Direct::Model::Creative::Constants;

=head1 NAME

=encoding utf8

Direct::Model::Creative::Constants - константы, связанные с креативами

=cut

use Direct::Modern;

=head2 ALLOWED_CANVAS_TAGS_BY_ADGROUP_TYPE

    Теги канваса и режимы конструктора, доступные для различных групп объявлений.
    Структура имеет три уровня: adgroup_type -> canvas_type -> canvas_tag.
    Тег (в формате tag: 1) фронт директа будет без обработки передавать фронту канваса.

=cut

use constant ALLOWED_CANVAS_TAGS_BY_ADGROUP_TYPE => {
    base               => {
        canvas => { base => 1 },
        video_addition  => { base => 1 },
    },
    mobile_content     => {
        video_addition => { mobile_content => 1 },
    },
    cpm_banner         => {
        canvas => { base => 1 },
        html5_creative  => { base => 1 },
    },
    cpm_video          => {
        video_addition => { cpm_video => 1 },
    },
    cpm_indoor         => {
        video_addition => { cpm_indoor => 1 },
    },
    cpm_outdoor        => {
        video_addition => { cpm_outdoor => 1 },
    },
    cpm_audio          => {
        video_addition => { cpm_audio => 1 },
    },
    cpm_geoproduct     => {
        canvas => { cpm_geoproduct => 1 },
        html5_creative  => { cpm_geoproduct => 1 },
    },
    cpm_yndx_frontpage => {
        html5_creative => { cpm_yndx_frontpage => 1 },
    },
};

=head2 OBSOLETE_LAYOUT_IDS

    id макетов, считающихся устаревшими (DIRECT-148277)

=cut

use constant OBSOLETE_LAYOUT_IDS => [1..7, 20..43];

1;
