package Direct::Model::Creative::Factory;

use Direct::Modern;
use Direct::Model::Creative;
use Direct::Model::CanvasCreative;
use Direct::Model::CanvasHtml5Creative;
use Direct::Model::VideoAddition;

sub create
{
    my ($class, $row, $cache, %opt) = @_;
    my $f_creative_type = join "", $opt{prefix}//'', "creative_type";
    my $model_class = 
          $row->{$f_creative_type} eq 'performance' ? Direct::Model::Creative->meta->name
        : $row->{$f_creative_type} eq 'video_addition' ? Direct::Model::VideoAddition->meta->name
        : $row->{$f_creative_type} eq 'canvas' ? Direct::Model::CanvasCreative->meta->name
        : $row->{$f_creative_type} eq 'html5_creative' ? Direct::Model::CanvasHtml5Creative->meta->name
        : die "unknown $f_creative_type '$row->{$f_creative_type}'";
    return $model_class->from_db_hash($row, $cache, %opt);
}

1;
