package Direct::Model::CreativeGroup;

use Direct::Modern;
use Mouse;
use Yandex::I18n;
use Direct::Model::Creative;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'perf_creatives',

    fields => [
        width                     => { type => 'Int' },
        height                    => { type => 'Int' },
        alt_text                  => { type => 'Maybe[Str]', length => 255 },
        preview_url               => { type => 'Str', length => 1024 },
        group_id                  => { type => 'Maybe[Int]', column => 'creative_group_id' },
        create_time               => { type => 'Maybe[Str]', column => 'group_create_time' },
        name                      => { type => 'Maybe[Str]', column => 'group_name' },
        template_id               => { type => 'Int' },
    ],
    
    additional => [
        creatives_data            => { type => 'ArrayRef[HashRef]' },
        group_creatives_count     => { type => 'Int' },
        total_counts              => { type => 'Int' },
        preview_scale             => { type=> 'Num', is => 'ro', builder => '_build_preview_scale' },
    ],
);

sub all_templates
{
    return Direct::Model::Creative::all_templates(@_);
}

sub _build_preview_scale
{
    return Direct::Model::Creative::_build_preview_scale(@_);
}

sub to_template_hash
{
    my $self = shift;
    $self->preview_scale();
    return $self->to_hash();
}

1;
