package Direct::Model::DynamicCondition::FeedRule;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;
use Carp qw/croak/;
use HashingTools qw/url_hash_utf8/;
use JSON;

use Yandex::ORM::Types;
use Yandex::I18n;

extends 'Direct::Model::PerformanceFilter::Rule';

sub get_uhash {
    my ($self) = @_;
    my $x = [$self->field, $self->has_relation && $self->relation, $self->has_value && [sort @{$self->value}]];
    return url_hash_utf8(JSON->new->utf8(0)->canonical->encode($x));
}

1;
