package Direct::Model::DynamicCondition::Rule;

use Direct::Modern;

use Mouse;
use Mouse::Util::TypeConstraints;
use Yandex::ORM::Types;
use FilterSchema;

use JSON;
use HashingTools qw/url_hash_utf8/;

my $schema = FilterSchema->new(filter_type => 'dynamic_conditions')->schema;
my $FIELDS = [ keys %{ $schema->{definitions}->{rule} }];
my $KINDS = $schema->{definitions}->{all_kinds};

has type  => (is => "rw", isa => enum($FIELDS), predicate => "has_type");
has kind  => (is => "rw", isa => enum($KINDS), predicate => "has_kind");
has value => (is => "rw", isa => "NonEmptyArrayRef[Str]", predicate => "has_value");

sub from_json_key_val {
    my ($class, $data) = @_;
    my %attr;
    # На время переходного периода произведём следующие замены:
    # kind: "match" -> "exact"
    # value: scalar -> arrayref
    $attr{type} = $data->{type};
    if ( exists $data->{kind} && defined $data->{kind} ) {
        $attr{kind} = $data->{kind};
        $attr{kind} =~ s/match$/exact/;
    }
    if ( exists $data->{value} ){
        $attr{value} = ref($data->{value}) ? $data->{value} : [$data->{value}];
    }
    return $class->new(%attr);
}

sub to_hash {
    my ($self) = @_;
    return {type => $self->type, $self->has_kind ? (kind => $self->kind) : (), $self->has_value ? (value => $self->value) : ()};
}

sub to_json_key_val {
    my ($self) = @_;
    
    return %{ $self->to_hash }
}

sub get_uhash {
    my ($self) = @_;
    my $x = [$self->type, $self->has_kind && $self->kind, $self->has_value && [sort @{$self->value}]];
    return url_hash_utf8(JSON->new->utf8(0)->canonical->encode($x));
}

1;
