package Direct::Model::FeedHistoryItem;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';

use Tools qw/encode_json_and_compress decode_json_and_uncompress/;

__PACKAGE__->_setup(
    default_table => 'perf_feed_history',

    fields => [
        id                              => { type => 'Id', primary_key => 1 },
        feed_id                         => { type => 'Id' },
        created_at                      => { type => 'Timestamp' },
        offers_count                    => { type => 'Maybe[Int]' },
        _parse_results_json_compressed  => { type => 'Maybe[Str]', column => 'parse_results_json_compressed' },
    ],

    relations => [
        parse_results                   => { type => 'Maybe[ArrayRef | HashRef]', trigger => \&_on_parse_results_changed },
        feed                            => { type => 'Direct::Model::Feed' },
    ],
);

around BUILDARGS => sub {
    my ($orig, $class) = (shift, shift);
    my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;

    if (exists $args{_parse_results_json_compressed}) {
        if (defined $args{_parse_results_json_compressed}) {
            eval { $args{parse_results} = decode_json_and_uncompress($args{_parse_results_json_compressed}); 1; } or do { croak "Cannot apply `_parse_results_json_compressed`: $@"; };
        } else {
            $args{parse_results} = undef;
        }
    }

    $class->$orig(%args);
};

sub _on_parse_results_changed {
    my ($self, $new) = @_;
    $self->_parse_results_json_compressed(defined $new ? encode_json_and_compress($new) : undef);
}

sub is_parse_results_changed { shift->_is_parse_results_json_compressed_changed(@_) }

1;
