package Direct::Model::Image;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';

__PACKAGE__->_setup(
    default_table  => 'images',

    fields => [
        id                        => { type => 'Id', column => 'image_id', primary_key => 1 },
        campaign_id               => { type => 'Id', column => 'cid' },
        adgroup_id                => { type => 'Maybe[Id]', column => 'pid' },
        banner_id                 => { type => 'Maybe[Id]', column => 'bid' },
        status_moderate           => { type => 'Enum', values => [qw/Yes No Sent Sending Ready New/], column => 'statusModerate', default => 'New', volatile => 1 },
        hash                      => { type => 'Str', column => 'image_hash' },
        image_text                => { type => 'Maybe[Str]', column => 'image_text' },
        disclaimer_text           => { type => 'Maybe[Str]', column => 'disclaimer_text' },
    ],

    relations => [
        format => { type => 'Direct::Model::ImageFormat', key => 'image_hash' },
        pool => { type => 'Direct::Model::ImagePool', key => 'image_hash' },
    ],

    # Additional attributes
    additional => [
        rejection_reason_ids => { type => 'ArrayRef[Int]',  default => sub { [] } },
        export_version       => { type => 'Maybe[Str]' },
    ],
);

sub get_name { return shift->pool->name; }
sub get_width { return shift->format->width; }
sub get_height { return shift->format->height; }
sub get_preview_url {
    my $self = shift;
    return qq!/images/${ \$self->format->namespace }/${ \$self->format->mds_group_id }/${ \$self->format->hash }!;
}
sub get_scale_size { return shift->format->get_scale_size(); }

sub to_template_hash
{
    my $self = shift;
    return {
        hash => $self->hash,
        # убрать все кроме hash после DIRECT-57421 # todo@dima117a не меняйте формат без согласования с фронтендом!!
        width => $self->format->width,
        height => $self->format->height,
        name => $self->pool->name,
        scale => $self->format->get_scale_size(),
        mds_group_id => $self->format->mds_group_id,
        namespace => $self->format->namespace,
        group_id => $self->format->mds_group_id, # для совместимости со старым кодом фронта
    };
}

1;

